%% (1) Setup

    clear; close all;
    addpath RedsSolds IRFs;
    computeIRFs=0;

    % get indices for variables and shocks
	[vrbs, type, shocks, nvar, nstate, nshock, nlag] = defineVariables();

   
    % get parameter values
    params = setParams();
 
%% (2) Define and Solve Rational Expectations Model

    % define equilibrium conditions
    [A, B, C] = defineREModel(vrbs,shocks,nvar,nshock,params);

    % solve using Reds-Solds algorithm
    [Br,Cr,Lr,NF] = redsf(A,B,C,nvar,nshock,nstate);
    [D,F,G,H] = soldsf(Br,Cr,Lr,nvar,nshock,nstate,NF);

    D = real(D); F = real(F); G = real(G); H = real(H);
   
    
    % Convert to VAR form
    [Omega_Z, Omega_epsilon] = getVAR(D,F,G,H,vrbs,type); 
   

    
    % produce Impulse Response Functions
    if computeIRFs
        nIterations = 10;                                                    % set number of iterations ahead
        spath       = 'S:\SHARE\drf\DSGELearning\Save\IRFs\';                % choose where to save IRFs
        allIRFs = getIRFs(nIterations,shocks,nshock,nvar,D,F,G,H);           % get matrix of all IRFs
        plotIRFs(allIRFs,vrbs,shocks,nshock,nIterations,spath,1);            % plot and save IRFs
    end

%% (3) Define Full Model

    % define equilibrium conditions
    [systemMats_full, lambda] = defineFullModel(vrbs,shocks,nvar,nshock,nlag,params);
    
       
%% (4) Compare Full Model to Rational Expectations Model

    [T_Z, T_epsilon] = fullToRE(systemMats_full,Omega_Z,lambda);
    
    
    if sum(sum(abs(T_Z-Omega_Z)))<1e-7
        disp('Good news: rational expectations model solves full model.');
    else
        disp('Bad news: rational expectations does not solve full model.');
    end
    






